<?php 
session_start();
include('connection.php');

if(isset($_SESSION['admin_login'])){
    $admin_username=$_SESSION['admin_login'];

//IF USER HAS LOGGED IN SHOW THE PAGE
?>



<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Write Announcement</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
</head>
<body>
    <div class="container mt-5">
        <h2>Create Announcement</h2>
        <form id="announcementForm">
            <div class="form-group">
                <label for="title">Announcement Title</label>
                <input type="text" class="form-control" id="title" name="title" placeholder="Enter title" required>
            </div>
            <div class="form-group">
                <label for="message">Message</label>
                <textarea class="form-control" id="message" name="message" rows="4" placeholder="Enter announcement message" required></textarea>
            </div>
               <div class="form-group">
                <label for="target_type">Posted To</label>
                <select class="form-control" id="posted_to" name="posted_to" required>
                    <option value="PARENTS">PARENTS</option>
                </select>
            </div>
            <div class="form-group">
                <label for="target_type">Target Type</label>
                <select class="form-control" id="target_type" name="target_type" required>
                    <option value="all">All Parents</option>
                 
                </select>
            </div>
           
            <div class="btn-group" role="group" aria-label="Admin Actions">
  <a href="admin_view_parentsannouncements.php" class="btn btn-primary">View Announcements</a>
  <!-- Add other action buttons here if needed -->
</div>

            <button type="submit" class="btn btn-primary">Submit Announcement</button>
        </form>
        <div id="responseMessage" class="mt-3"></div>
    </div>

    <script>
        $(document).ready(function(){
            // Toggle parent username input field based on target type
            $('#target_type').change(function() {
                if ($(this).val() === 'specific') {
                    $('#parent_username_div').show();
                } else {
                    $('#parent_username_div').hide();
                }
            });

            // Handle form submission via AJAX
            $('#announcementForm').submit(function(e) {
                e.preventDefault();

                var title = $('#title').val();
                var message = $('#message').val();
                var announcement_date = $('#announcement_date').val();
                var target_type = $('#target_type').val();
                var parent_username = target_type === 'specific' ? $('#parent_username').val() : null;

                // Send AJAX request to process announcement
                $.ajax({
                    url: 'process_parent_announcement.php',
                    method: 'POST',
                    data: {
                        title: title,
                        message: message,
                        announcement_date: announcement_date,
                        target_type: target_type,
                        parent_username: parent_username
                    },
                    success: function(response) {
                        $('#responseMessage').html(response);
                        $('#announcementForm')[0].reset();
                    },
                    error: function() {
                        $('#responseMessage').html('<div class="alert alert-danger">Error submitting announcement.</div>');
                    }
                });
            });
        });
    </script>
</body>
</html>




<?php
//IF USER HAS NOT LOGGED IN , SHOW THIS ALERT
};




// Example of checking if the user is an admin
if(!isset($_SESSION['admin_login'])) {
    // If the user is not an admin, show a nice access denied message
    echo '
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Access Denied</title>
        <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    </head>
    <body>
        <div class="container mt-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="alert alert-danger text-center p-5" role="alert">
                        <h4 class="alert-heading">Access Denied!</h4>
                        <p class="lead">It seems you are not an admin. You do not have permission to access this page.</p>
                        <hr>
                        <p>Please contact the system administrator for further assistance.</p>
                        <a href="index.php" class="btn btn-outline-danger mt-3">Return to Homepage</a>
                    </div>
                </div>
            </div>
        </div>
        <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    </body>
    </html>';
    
    exit(); // Prevent further code execution
}
?>
